document.addEventListener("DOMContentLoaded", function () {

  // CATEGORY → DEPARTMENT → DESIGNATION
  const data = {
    Doctor: {
      departments: ["Medicine", "Surgery", "ICU"],
      designations: ["Medical Officer", "Consultant", "Registrar"]
    },
    Engineer: {
      departments: ["IT", "Maintenance"],
      designations: ["IT Engineer", "Maintenance Engineer"]
    },
    Nurse: {
      departments: ["Nursing", "ICU"],
      designations: ["Staff Nurse", "Senior Nurse"]
    },
    General: {
      departments: ["Accounts", "HR", "Security"],
      designations: ["Officer", "Manager", "Security Guard"]
    }
  };

  const category = document.getElementById("category");
  const department = document.getElementById("department");
  const designation = document.getElementById("designation");

  category.addEventListener("change", function () {
    department.innerHTML = '<option value=""></option>';
    designation.innerHTML = '<option value=""></option>';

    if (!data[this.value]) return;

    data[this.value].departments.forEach(d =>
      department.appendChild(new Option(d, d))
    );
    data[this.value].designations.forEach(d =>
      designation.appendChild(new Option(d, d))
    );
  });

  // SAME AS PRESENT ADDRESS
  const same = document.getElementById("sameAddress");
  const p = ["p_village","p_post","p_thana","p_district"];
  const pr = ["pr_village","pr_post","pr_thana","pr_district"];

  same.addEventListener("change", function () {
    if (this.checked) {
      p.forEach((id,i)=>{
        document.getElementById(pr[i]).value =
          document.getElementById(id).value;
        document.getElementById(pr[i]).readOnly = true;
      });
    } else {
      pr.forEach(id=>{
        document.getElementById(id).readOnly = false;
        document.getElementById(id).value = "";
      });
    }
  });

  p.forEach((id,i)=>{
    document.getElementById(id).addEventListener("input", ()=>{
      if (same.checked) {
        document.getElementById(pr[i]).value =
          document.getElementById(id).value;
      }
    });
  });

  document.getElementById("employeeForm").addEventListener("reset", ()=>{
    same.checked = false;
    pr.forEach(id=>document.getElementById(id).readOnly=false);
  });

});
